﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace findImage
{
    public partial class SettingForm : Form
    {
        MainWindow mainWindow;

        public SettingForm(MainWindow mainWindow)
        {
            this.mainWindow = mainWindow;
            InitializeComponent();
            textBoxSusiePath.Text = mainWindow.susiePath;
            int maxCand = mainWindow.maxCandidate;
            textBoxMaxCand.Text = maxCand.ToString();
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            int maxCand = 0;
            try
            {
                maxCand = int.Parse(textBoxMaxCand.Text);
            }
            catch (Exception) { }

            if (maxCand <= 0)
            {
                MessageBox.Show("検索結果の表示枚数は1以上の整数で指定してください", "設定値エラー", MessageBoxButtons.OK);
                return;
            }

            mainWindow.susiePath = textBoxSusiePath.Text;
            mainWindow.maxCandidate = maxCand;
            this.Close();
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void textBoxSusiePath_DragEnter(object sender, DragEventArgs e)
        {
            e.Effect = DragDropEffects.All;
        }

        private void textBoxSusiePath_DragDrop(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                textBoxSusiePath.Text = ((string[])e.Data.GetData(DataFormats.FileDrop))[0];
            }
        }
    }
}
