﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Text;
using System.Windows.Forms;
using MFLib;

namespace findImage
{
    public partial class SelectFilesFromSusieCatalog : Form
    {
        public bool isCancel { get; private set; }  // このフォーム終了が、キャンセルなのかOKなのか

        // FlowLayoutのソート用
        List<Thumbnail> thumbnailList = new List<Thumbnail>();

        // GUI用
        int flowLayoutPanel_horizontalMargin;
        int flowLayoutPanel_verticalMargin;
        enum SortType { none, FnameUp, FnameDown, ExtUp, ExtDown, TimeUp, TimeDown, LengthUp, LengthDown };
        static SortType lastSortType = SortType.none;

        public SelectFilesFromSusieCatalog()
        {
            InitializeComponent();

            // 変数初期化
            isCancel = true;

            // GUIの設定
            flowLayoutPanel_horizontalMargin = ClientRectangle.Width - flowLayoutPanelCatalog.Width;
            flowLayoutPanel_verticalMargin = ClientRectangle.Height - flowLayoutPanelCatalog.Height;

            // ラジオボタンの設定は実に面倒だ
            radioButtonSusie.Tag = SortType.none;
            radioButtonSusie.Checked = (lastSortType == SortType.none);
            radioButtonFilenameUp.Tag = SortType.FnameUp;
            radioButtonFilenameUp.Checked = (lastSortType == SortType.FnameUp);
            radioButtonFilenameDown.Tag = SortType.FnameDown;
            radioButtonFilenameDown.Checked = (lastSortType == SortType.FnameDown);
            radioButtonExtnameUp.Tag = SortType.ExtUp;
            radioButtonExtnameUp.Checked = (lastSortType == SortType.ExtUp);
            radioButtonExtnameDown.Tag = SortType.ExtDown;
            radioButtonExtnameDown.Checked = (lastSortType == SortType.ExtDown);
            radioButtonDateUp.Tag = SortType.TimeUp;
            radioButtonDateUp.Checked = (lastSortType == SortType.TimeUp);
            radioButtonDateDown.Tag = SortType.TimeDown;
            radioButtonDateDown.Checked = (lastSortType == SortType.TimeDown);
            radioButtonSizeUp.Tag = SortType.LengthUp;
            radioButtonSizeUp.Checked = (lastSortType == SortType.LengthUp);
            radioButtonSizeDown.Tag = SortType.LengthDown;
            radioButtonSizeDown.Checked = (lastSortType == SortType.LengthDown);

        }

        
        public void SetSusieCatalog(string fname)
        {
            // カタログを追加する
            using (var susiecat = new SusieCat(fname))
            {
                int no = 0;     // 何番目のサムネイルか？

                while (susiecat.NextThumb())
                {
                    var bmp = susiecat.getBitmap();
                    var thumbnail = new Thumbnail(bmp, susiecat.fname, susiecat.time, susiecat.length, no, this);

                    thumbnailList.Add(thumbnail);
                } // while
            } // using

            // 表示する
            SortAndDisplay();
        }

        // thumbnailListをlastSortTypeに従ってソートして、表示する
        void SortAndDisplay()
        {
            Comparison<Thumbnail> comp;
            // ソートに使う関数を選ぶ
            switch (lastSortType)
            {
                case SortType.none:
                    comp = Thumbnail.CompareByNo;
                    break;
                case SortType.FnameUp:
                    comp = Thumbnail.CompareByFnameUp;
                    break;
                case SortType.FnameDown:
                    comp = Thumbnail.CompareByFnameDown;
                    break;
                case SortType.ExtUp:
                    comp = Thumbnail.CompareByExtUp;
                    break;
                case SortType.ExtDown:
                    comp = Thumbnail.CompareByExtDown;
                    break;
                case SortType.TimeUp:
                    comp = Thumbnail.CompareByTimeUp;
                    break;
                case SortType.TimeDown:
                    comp = Thumbnail.CompareByTimeDown;
                    break;
                case SortType.LengthUp:
                    comp = Thumbnail.CompareByLengthUp;
                    break;
                case SortType.LengthDown:
                    comp = Thumbnail.CompareByLengthDown;
                    break;
                default:
                    comp = null;
                    break;
            }
            thumbnailList.Sort(comp);

            // 表示する
            flowLayoutPanelCatalog.Controls.Clear();
            for (int i = 0; i < thumbnailList.Count; i++)
            {
                Thumbnail thumb = thumbnailList[i];
                thumb.currentNo = i;
                flowLayoutPanelCatalog.Controls.Add(thumb);
            }
        }

        // Thumbnailから呼ばれる。
        // どれかのサムネイルが選択された
        int lastSelectNo = 0;     // shiftキーで選択するとき用
        public void Thumbnail_Click(Thumbnail sender, bool control, bool shift)
        {
            if (shift) // 前回選択から今回選択までを追加
            {
                int from;
                int to;
                Misc.GetMinMax(sender.currentNo, lastSelectNo, out from, out to);
                for (int i = from; i <= to; i++)
                {
                    thumbnailList[i].isSelected = true;
                }
            }
            else if (control) // 今回選択を追加
            {
                sender.isSelected = true;
            }
            else
            {
                foreach (Thumbnail thumb in thumbnailList)
                {
                    thumb.isSelected = false;
                }
                sender.isSelected = true;
            }
            lastSelectNo = sender.currentNo;
        }

        // (次の)選択した画像を得る
        int lastGetNo;
        public bool GetNextImage(out Bitmap bmp, out string fname)
        {
            bmp = null;
            fname = null;
            if (isCancel) return false;

            while (lastGetNo < thumbnailList.Count)
            {
                int idx = lastGetNo++;
                if (thumbnailList[idx].isSelected)
                {
                    bmp = thumbnailList[idx].bitmap;
                    fname = thumbnailList[idx].thumb_fname;
                    return true;
                }
            }
            return false;
        }

        #region GUIのコールバック
        // cancel
        private void buttonCancel_Click(object sender, EventArgs e)
        {
            isCancel = true;
            this.Close();
        }

        // OK
        private void buttonOK_Click(object sender, EventArgs e)
        {
            isCancel = false;
            lastGetNo = 0;
            this.Close();
        }

        // ソート方法を変更するラジオボタンが押された
        private void radioButton_CheckedChanged(object sender, EventArgs e)
        {
            SortType sortType = (SortType)((RadioButton)sender).Tag;
            lastSortType = sortType;
            lastSelectNo = 0;
            SortAndDisplay();
        }

        // フォームがリサイズされた
        private void SelectFilesFromSusieCatalog_Resize(object sender, EventArgs e)
        {
            flowLayoutPanelCatalog.Size = new Size(ClientRectangle.Width - flowLayoutPanel_horizontalMargin, ClientRectangle.Height - flowLayoutPanel_verticalMargin);
        }
        #endregion
    }

    // flowLayoutPanelに表示するコントロール
    [System.ComponentModel.DesignerCategory("")]
    public class Thumbnail : Panel
    {
        // GUI
        const int WIDTH = 100;
        const int HEIGHT = 128;
        const int ICON_SIZE = 96;
        const int ICON_MARGIN = 3;
        PictureBox pictureBox;
        Label label;
        bool __isSelected;      // アクセサ以外からのアクセスを禁止できないものかね？
        public bool isSelected
        {
            get
            {
                return this.__isSelected;
            }
            set
            {
                this.__isSelected = value;
                SetBackColor();
            }
        }

        // ソートに使う
        public string thumb_fname { get; private set; } // ファイル名
        string thumb_ext;   // 拡張子
        UInt32 thumb_time;  // 時刻
        long thumb_length;  // サイズ
        int thumb_no;       // 元のカタログ内の位置

        // その他
        SelectFilesFromSusieCatalog parent;     // 親フォーム
        public int currentNo;                   // 現在の番号
        public Bitmap bitmap { get; private set; }

        public Thumbnail(Bitmap bmp, string fname, UInt32 time, long length, int no, SelectFilesFromSusieCatalog parent )
            : base()
        {
            thumb_fname = fname;
            thumb_ext = Path.GetExtension(fname);
            thumb_time = time;
            thumb_length = length;
            thumb_no = no;
            this.parent = parent;
            bitmap = bmp;

            // 画像の表示
            pictureBox = new PictureBox();
            pictureBox.Size = new Size(ICON_SIZE, ICON_SIZE);
            pictureBox.BorderStyle = BorderStyle.None;
            pictureBox.SizeMode = PictureBoxSizeMode.CenterImage;
            pictureBox.Image = bmp;
            pictureBox.Location = new Point((WIDTH-ICON_SIZE)/2, ICON_MARGIN);
            pictureBox.Click+=new EventHandler(Thumbnail_Click);
            Controls.Add(pictureBox);

            // 文字列の表示
            label = new Label();
            label.Text = fname;
            label.Size = new Size(WIDTH, HEIGHT - ICON_SIZE);
            label.Location = new Point(0, ICON_SIZE+ICON_MARGIN*2);
            label.TextAlign = ContentAlignment.TopCenter;
            label.Click+=new EventHandler(Thumbnail_Click);
            Controls.Add(label);

            // 自分自身の設定
            Size = new Size(WIDTH, HEIGHT);
            SetBackColor();
            Margin = new Padding(1);    // FlowLayoutControlで使われる間隔
            Click+=new EventHandler(Thumbnail_Click);
        }


        // クリック時
        void Thumbnail_Click(object sender, EventArgs e)
        {
            bool shift = (ModifierKeys == Keys.Shift);
            bool control = (ModifierKeys == Keys.Control);
            parent.Thumbnail_Click(this, control, shift);
        }        

        void SetBackColor()
        {
            if (isSelected)
            {
                BackColor = Color.BlanchedAlmond;
            }
            else
            {
                BackColor = Color.White;
            }
        }

        #region ソート用比較関数
        // 番号昇順
        public static int CompareByNo(Thumbnail a, Thumbnail b)
        {
            var p = a.thumb_no; // 一度コピーしないと参照マーシャリングクラスのフィールドであるというwarningが出る
            return p.CompareTo(b.thumb_no);
        }
        // 名前昇順
        public static int CompareByFnameUp(Thumbnail a, Thumbnail b)
        {
            var p = a.thumb_fname;
            return p.CompareTo(b.thumb_fname);
        }
        // 名前降順
        public static int CompareByFnameDown(Thumbnail a, Thumbnail b)
        {
            var p = b.thumb_fname;
            return p.CompareTo(a.thumb_fname);
        }
        // 拡張子昇順
        public static int CompareByExtUp(Thumbnail a, Thumbnail b)
        {
            var p = a.thumb_ext;
            return p.CompareTo(b.thumb_ext);
        }
        // 拡張子降順
        public static int CompareByExtDown(Thumbnail a, Thumbnail b)
        {
            var p = b.thumb_ext;
            return p.CompareTo(a.thumb_ext);
        }
        // 日付昇順
        public static int CompareByTimeUp(Thumbnail a, Thumbnail b)
        {
            var p = a.thumb_time;
            return p.CompareTo(b.thumb_time);
        }
        // 日付降順
        public static int CompareByTimeDown(Thumbnail a, Thumbnail b)
        {
            var p = b.thumb_time;
            return p.CompareTo(b.thumb_time);
        }
        // サイズ昇順
        public static int CompareByLengthUp(Thumbnail a, Thumbnail b)
        {
            var p = a.thumb_length;
            return p.CompareTo(b.thumb_length);
        }
        // サイズ降順
        public static int CompareByLengthDown(Thumbnail a, Thumbnail b)
        {
            var p = b.thumb_length;
            return p.CompareTo(a.thumb_length);
        }
        #endregion

    }

}
