﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Imaging;
using System.Runtime.InteropServices;
using MFLib;

namespace findImage
{
    // 検索する画像を格納するクラス
    public class SearchData
    {
        public readonly int[] THUMBNAIL_SIZE = new int[] { 48, 64, 80, 96 };
        public Bitmap thumbnail { get; private set; }       // 表示用の96x96サムネイル
        public bool enable { get; private set; }
        MainWindow mainWindow;
        MyTabPage tabPage;                                  // 自分が属しているtabPage
 
        // 検索時に使用するデータ
        public string searchFileName { get; private set; }
        public int[] width;
        public int[] height;
        public Byte[][] data2D;         // 2次元比較用データ
        public bool available { get; private set; }
        
        public SearchData(MainWindow mainWindow, MyTabPage tabPage)
        {
            this.mainWindow = mainWindow;
            this.tabPage = tabPage;
            searchFileName = null;
            enable = false;
            data2D = new Byte[THUMBNAIL_SIZE.Length][];
            available = false;
            for (int i = 0; i < THUMBNAIL_SIZE.Length; i++)
            {
                data2D[i] = new Byte[3 * THUMBNAIL_SIZE[i] * THUMBNAIL_SIZE[i]];
            }
            width = new int[THUMBNAIL_SIZE.Length];
            height = new int[THUMBNAIL_SIZE.Length];
        }

        // 検索用データとタブに表示するサムネイルを作成する
        public void SetImage(Bitmap bmp)
        {
            BitmapData orgData = bmp.LockBits(new Rectangle(0, 0, bmp.Width, bmp.Height), ImageLockMode.ReadOnly, PixelFormat.Format24bppRgb);

            // susieのサムネイルの４サイズに合わせた検索用データの作成
            for (int i = 0; i < THUMBNAIL_SIZE.Length; i++)
            {
                // 2次元比較用縮小画像の作成
                int width;
                int height;
                int sz = THUMBNAIL_SIZE[i];

                // 2次元比較用データ作成
                ImageProcess.CalcSmallSize(bmp.Width, bmp.Height, sz, out width, out height);
                this.width[i] = width;
                this.height[i] = height;
                ImageProcess.resizeImage(orgData.Scan0, orgData.Width, orgData.Height, orgData.Stride,
                    data2D[i], width, height, width * 3);

                if (sz == 96)
                {
                    // タブに表示する、検索対象画像のbitmap化
                    thumbnail = new Bitmap(width, height);
                    ImageProcess.resizeImage(data2D[i], width, height, width * 3,
                        thumbnail);
                }

                // データの方は正順に並べ替える
                // (susieのサムネイルは画面の左上が、[0])
                ImageProcess.flipud(data2D[i], width * 3, height);
            }
            bmp.UnlockBits(orgData);
            available = true;
        }
    }
}
