﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using MFLib;


namespace findImage
{
    public partial class MainWindow : Form
    {
        // ■■メンバ変数■■■■■■■■■■■■■■■■■■■■
        // 設定値
        public int maxCandidate;    // 候補の最大数
        public string susiePath;    // susieのパス

        // いろいろ
        Search search = Search.GetInstance();   // 検索に使う
        bool canResume = false;                 // Resume可能かどうか(１度でもstartしていればtrue)
        string searchDir = null;                // 検索を開始するディレクトリ

        // ■■コンストラクタ■■■■■■■■■■■■■■■■■■■■
        public MainWindow()
        {
            ReadSetting();
            InitializeComponent();
          
            AddNewTab();
            ManageButtonEnable();
            textBoxSeachDir.KeyDown+=new KeyEventHandler(textBoxSeachDir_KeyDown);
        }


        // ■■bgWorker関係■■■■■■■■■■■■■■■■■■■■
        public bool IsBusy()
        {
            return bgWorker.IsBusy;
        }

        // バックグラウンドで検索を行う
        private void bgWorker_DoWork(object sender, DoWorkEventArgs e)
        {
            search.Run(sender, e);
        }

        private void bgWorker_ProgressChanged(object sedner, ProgressChangedEventArgs e)
        {
            progressBar.Value = e.ProgressPercentage;
        }

        // 検索終了もしくはキャンセル
        private void bgWorker_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            if (e.Cancelled)
            {
                canResume = true;
            }
            else
            {
                canResume = false;
                textBoxSearchingDir.Text = "検索終了";
            }
            ManageButtonEnable();
        }

        public void SetSearchingDir(string dir)
        {
            textBoxSearchingDir.Text = dir;
        }

        // ■■設定ファイル関連■■■■■■■■■■■■■■■■■■■■
        // http://dobon.net/vb/dotnet/programing/mysettings.htmlを参照
        void ReadSetting()
        {
            maxCandidate = Properties.Settings.Default.maxCand;
            susiePath = Properties.Settings.Default.susiePath;
        }

        void WriteSetting()
        {
            Properties.Settings.Default.maxCand = maxCandidate;
            Properties.Settings.Default.susiePath = susiePath;
            Properties.Settings.Default.Save();
        }
        
        // ■■GUI描画■■■■■■■■■■■■■■■■■■■■
        // 新しいタブを追加する
        public MyTabPage AddNewTab()
        {
            IntPtr tabHandle = tabControl.Handle;       // 使わないけど重要なおまじない
            int tabCount = tabControl.TabCount;

            // TabPageを作成
            MyTabPage tabPage = new MyTabPage( this );

            // TabControlに追加
            tabControl.TabPages.Insert(tabCount - 1, tabPage);
            tabControl.SelectedIndex = tabCount - 1;
            return tabPage;
        }

        // あるタブを削除する
        public void DeleteTab(MyTabPage tabPage)
        {
            if (tabControl.Controls.Contains(tabPage))
            {
                tabControl.Controls.Remove(tabPage);
            }
        }

        // 現在の状態に合わせてボタンのenableを設定する
        // 注意:
        // ボタンには先行入力もあるので、
        // 各ボタンのコールバックでは、状況判断をGUIのenableに任せず
        // 必ず、IsBusy()を見て確認すること！
        // そうしないと、たとえば「開始」と「再開」を続けて押された時に
        // 両方走る可能性が残る。
        // チェックはコールバックの先頭で普通に行えばOK。
        // GUIのスレッドは１つなので、たとえば「開始」が動き始めたら、
        // 開始のコールバックが終わるまで、
        // 「再開」のコールバックが呼ばれないことは保証されているため。
        public void ManageButtonEnable()
        {
            if (IsBusy())
            {
                buttonStartSearch.Enabled = false;
                buttonResumeSearch.Enabled = false;
                buttonStopSearch.Enabled = true;
                buttonClearResult.Enabled = false;
                textBoxSeachDir.Enabled = false;
                buttonSetting.Enabled = false;
            }
            else
            {
                buttonStartSearch.Enabled = true;
                buttonResumeSearch.Enabled = canResume;
                buttonStopSearch.Enabled = false;
                buttonClearResult.Enabled = search.canClear;
                textBoxSeachDir.Enabled = true;
                buttonSetting.Enabled = true;
            }
        }

        public void DrawMessage(string str)
        {
            textBoxMessage.AppendText(str);
        }

        // ■■MainWindow直下のイベントハンドラ■■■■■■■■■■■■■■■■■■■■
        // textBoxImageToSearchでenterキーが押されたときの処理
        private void textBoxSeachDir_KeyDown(object sender, KeyEventArgs e)
        {
            if (IsBusy()) return;

            if (e.KeyCode == Keys.Enter)
            {
                searchDir = textBoxSeachDir.Text;
            }
        }
        // 検索開始ボタン
        private void buttonStartSearch_Click(object sender, EventArgs e)
        {
            if (IsBusy()) return;
            search.Clear();
            StartSearch(false);
        }

        // 検索再開
        private void buttonResumeSearch_Click(object sender, EventArgs e)
        {
            if (IsBusy()) return;
            StartSearch(true);
        }

        private void StartSearch(bool resume)
        {
            if (IsBusy() || searchDir == null) return;
            if (resume)
            {
                search.Init(this, tabControl);
            }
            else
            {
                search.Init(this, tabControl, searchDir);
            }
            bgWorker.RunWorkerAsync();  // 別スレッドで検索開始
            ManageButtonEnable();
        }

        // 検索の中断
        private void buttonStopSearch_Click(object sender, EventArgs e)
        {
            if (!IsBusy()) return;
            bgWorker.CancelAsync();
        }

        // 検索結果の初期化
        private void buttonClearResult_Click(object sender, EventArgs e)
        {
            if (IsBusy()) return;
            search.Clear();
            ManageButtonEnable();
        }

        // tabPageを選択した
        private void tabControl_SelectedIndexChanged(object sender, EventArgs e)
        {
            TabControl tb = sender as TabControl;
            int tabCount = tabControl.TabCount;
            if (tb.SelectedIndex == tabCount - 1)
            {
                // 検索画像を追加するタブを選んだとき
                if (IsBusy()) return;
                AddNewTab();
            }
            else
            {
                ((MyTabPage)tb.Controls[tb.SelectedIndex]).ManageButtonEnable();
            }
        }

        // サーチ開始ディレクトリにドラッグ中
        private void textBoxSeachDir_DragEnter(object sender, DragEventArgs e)
        {
            if (IsBusy()) return;
            e.Effect = DragDropEffects.All;
        }

        // ドロップされた
        private void textBoxSeachDir_DragDrop(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                textBoxSeachDir.Text = ((string[])e.Data.GetData(DataFormats.FileDrop))[0];
                // searchStartDir = textBoxSeachDir.Text;   // 発生するTextChangedイベントに任せる
            }
        }

        // サーチ開始ディレクトリの「参照」
        private void buttonRefSearchDir_Click(object sender, EventArgs e)
        {
            if (IsBusy()) return;
            var dlg = new FolderBrowserDialog();
            dlg.Description = "検索を開始するフォルダを指定してください";
            dlg.ShowNewFolderButton = false;
            if (dlg.ShowDialog(this) == DialogResult.OK)
            {
                textBoxSeachDir.Text = dlg.SelectedPath;
                // searchStartDir = textBoxSeachDir.Text;   // 発生するTextChangedイベントに任せる
            }

        }

        // サーチ開始ディレクトリが手入力された
        private void textBoxSeachDir_TextChanged(object sender, EventArgs e)
        {
            searchDir = textBoxSeachDir.Text;
        }

        // 設定 
        private void buttonSetting_Click(object sender, EventArgs e)
        {
            if (IsBusy()) return;
            using (var settingForm = new SettingForm(this))
            {
                settingForm.ShowDialog();
            }
        }

        // 終了時の処理
        private void MainWindow_FormClosed(object sender, FormClosedEventArgs e)
        {
            // 設定の保存
            WriteSetting();
        }
    }
}
