﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Imaging;
using System.Runtime.InteropServices;
using System.Diagnostics;

namespace MFLib
{
    // ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
    // よく使う計算やパターンをまとめたstatic class
    static class Misc
    {
        // 大きい方と小さい方を得る
        static public void GetMinMax(int a, int b, out int min, out int max)
        {
            if (a > b)
            {
                min = b;
                max = a;
            }
            else
            {
                min = a;
                max = b;
            }
        }

        // 拡張子から、エクスプローラで関連付けされたプログラムを探す
        // 出力
        //  戻り値      プログラム名
        //  commanPath  プログラムの絶対パス
        //  commandArg  引数。「-o {0}」のように、C#の書式になっている
        // エラー時
        //  何らかの例外が発生します。
        static public string GetProgramFromExt(string ext, out string commandPath, out string commandArg )
        {
            // http://dobon.net/vb/dotnet/system/findassociatedexe.htmlの方法
            // 僕の環境だと、エクスプローラのデフォルトに割り当てていないshimgvwになってしまう
            // windowsのデフォルトとエクスプローラのデフォルトが異なっているということか？
#if false
                try
                {
                    string ext = Path.GetExtension(c.thumbFname);
         
                    // ファイルタイプを取得
                    string fileType;
                    using (var regKey = Microsoft.Win32.Registry.ClassesRoot.OpenSubKey(ext))
                    {
                        if (regKey == null) return;     // 関連付けされていない
                        fileType = (string)regKey.GetValue("");
                    } // using

                    // ファイルタイプを開くプログラムを取得
                    string command;
                    using (var regKey = Microsoft.Win32.Registry.ClassesRoot.OpenSubKey(
                        string.Format(@"{0}\shell\{1}\command", fileType, "start")))
                    {
                        if (regKey == null) return;
                        command = (string)regKey.GetValue("");
                    }

                    Console.WriteLine(command);
                }
                catch (Exception) { }
#endif

            // エクスプローラが拡張子に割り当てているコマンドを探す
            string commandName;
            using (var rkCurrentUser = Microsoft.Win32.Registry.CurrentUser)
            {
                string key = @"Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\" + ext.ToLower();
                using (var regKey = rkCurrentUser.OpenSubKey(key))
                {
                    commandName = (string)regKey.GetValue("Application");
                }
            }

            // 次にそのコマンドの実行方法を探す
            string shellOpenCommand;
            using (var rkClassesRoot = Microsoft.Win32.Registry.ClassesRoot)
            {
                string key = @"Applications\" + commandName + @"\shell\open\command";
                using (var regKey = rkClassesRoot.OpenSubKey(key))
                {
                    shellOpenCommand = (string)regKey.GetValue("");
                }
            }

            // shellOpenCommandは、「"c:\foo\bar.exe" -o "%1"」のようになっている
            //これをC#の文字列フォーマット形式「c:\foo\bar.exe -o {0}」に変換する
            string[] splitedCommand = shellOpenCommand.Replace("%1", "{0}").Split('"');
            commandPath = splitedCommand[1];
            commandArg = "";
            for (int i = 3; i < splitedCommand.Length; i++)
            {
                if (i == 1)
                {
                    commandArg += splitedCommand[i];
                }
                else
                {
                    commandArg += " " + splitedCommand[i];
                }
            }
            return commandName;
        }

    }

    // ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
    // オブジェクト対の格納につかうクラス
    public class Pair<S,T>
    {
        public S First;
        public T Second;

        public Pair()
        {
        }

        public Pair( S first, T second)
        {
            First = first;
            Second = second;
        }
    }



    // ■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
    // 画像関係
    public class ImageProcess
    {
        // リソースからビットマップを読み込む
        static public Bitmap getBitmapFromResource(string bitmapName)
        {
            var asm = System.Reflection.Assembly.GetExecutingAssembly();
            var bitmap = new Bitmap(asm.GetManifestResourceStream(bitmapName));
            return bitmap;
        }

        // bitmap等の画像をsusieのサムネイルと「たぶん同じ考え方」で縮小する
        // (単に縮小したいだけなら、Graphicsをつかうべき)
        // 引数
        //  src                 原画
        //  srcWidth, srcHeight 原画サイズ
        //  srcStride           原画の水平バイト数
        //  dst                 出力(あらかじめ確保しておくこと)
        //  dstWidth, dstHeight 出力サイズ
        //  dstStride           出力の水平バイト数
        //
        // 備考
        //  コンパイルするときは、
        //  プロジェクトのプロパティの「ビルド」のページにある
        //  「アンセーフコードの許可(U)」にチェックを入れること
        // 備考その2
        //  スピードは、まずまず。
        //  GraphicsのHighQualityBicubicより1割遅いくらい
        // 注意
        //  得られる画像はsusieのサムネイルとは一致はしない！！
        //  susieの拡大・縮小アルゴリズムには、たぶんバグがある。
        //  比の計算にたぶん間違いがあり、縮小比によっては縮小率がずれていく。
        //  これを再現したかったのだが、どうしても再現できなかった…
        //  そのため、susieのサムネイルを完全に一致する画像を作ることができない。
        //  これが、検索したい画像を選ぶときに、わざわざsusieのサムネイルから選ばせる理由。
        unsafe static public void resizeImage(byte* src, int srcWidth, int srcHeight, int srcStride,
            byte* dst, int dstWidth, int dstHeight, int dstStride)
        {

            unsafe
            {
                byte[] buffer = new byte[srcHeight * dstWidth * 3];
                fixed (byte* buff = buffer)
                {
                    // バッファを初期化
                    {
                        byte* p = buff;
                        for (int i = 0; i < srcHeight * dstWidth * 3; i++)
                        {
                            *p++ = 0;
                        }
                    }

                    // まず水平方向処理
                    if (dstWidth <= srcWidth)
                    {
                        #region 水平縮小処理
                        byte* srcY = src;
                        byte* dstY = buff;
                        for (int y = 0; y < srcHeight; y++)
                        {
                            byte* dstB = dstY;
                            byte* dstG = dstY + 1;
                            byte* dstR = dstY + 2;
                            byte* srcB = srcY;
                            byte* srcG = srcY + 1;
                            byte* srcR = srcY + 2;
                            int srcRestX = srcWidth;
                            int dstRestX = dstWidth;

                            int x = 0;
                            int sumB = 0;
                            int sumG = 0;
                            int sumR = 0;
                            while (x < dstWidth)
                            {
                                int N = (dstRestX < srcRestX) ? dstRestX : srcRestX;

                                sumB += *srcB * N;
                                sumG += *srcG * N;
                                sumR += *srcR * N;

                                dstRestX -= N;
                                if (dstRestX == 0)
                                {
                                    srcB += 3;
                                    srcG += 3;
                                    srcR += 3;
                                    dstRestX = dstWidth;
                                }

                                srcRestX -= N;
                                if (srcRestX == 0)
                                {
                                    *dstB = (byte)(sumB / srcWidth);
                                    *dstG = (byte)(sumG / srcWidth);
                                    *dstR = (byte)(sumR / srcWidth);
                                    dstB += 3;
                                    dstG += 3;
                                    dstR += 3;
                                    x++;
                                    srcRestX = srcWidth;
                                    sumB = 0;
                                    sumG = 0;
                                    sumR = 0;
                                }
                            } // while

                            srcY += srcStride;
                            dstY += dstWidth * 3;
                        } // for
                        #endregion //水平縮小処理
                    }
                    else
                    {
                        #region 水平拡大処理
                        byte* srcY = src;
                        byte* dstY = buff;
                        for (int y = 0; y < srcHeight; y++)
                        {
                            byte* dstB = dstY;
                            byte* dstG = dstY + 1;
                            byte* dstR = dstY + 2;
                            byte* srcB = srcY;
                            byte* srcG = srcY + 1;
                            byte* srcR = srcY + 2;
                            int dstRestX = dstWidth;

                            int x = 0;
                            while (x < dstWidth)
                            {
                                if (dstRestX > srcWidth)
                                {
                                    *dstB = *srcB;
                                    *dstG = *srcG;
                                    *dstR = *srcR;
                                    dstRestX -= srcWidth;
                                }
                                else
                                {
                                    int N = srcWidth - dstRestX;
                                    *dstB = (byte)((*srcB * (srcWidth - N) + *(srcB + 3) * N) / srcWidth);
                                    *dstG = (byte)((*srcG * (srcWidth - N) + *(srcG + 3) * N) / srcWidth);
                                    *dstR = (byte)((*srcR * (srcWidth - N) + *(srcR + 3) * N) / srcWidth);
                                    srcB += 3;
                                    srcG += 3;
                                    srcR += 3;
                                    dstRestX = dstWidth - N;
                                }

                                dstB += 3;
                                dstG += 3;
                                dstR += 3;
                                x++;
                            } // while

                            srcY += srcStride;
                            dstY += dstWidth * 3;
                        } // for
                        #endregion //水平拡大処理
                    }

                    // 次に垂直方向処理
                    if (dstHeight < srcHeight)
                    {
                        #region 垂直縮小処理
                        int sStride = dstWidth * 3;
                        byte* srcX = buff;
                        byte* dstX = dst;
                        for (int x = 0; x < dstWidth; x++)
                        {
                            byte* dstB = dstX;
                            byte* dstG = dstX + 1;
                            byte* dstR = dstX + 2;
                            byte* srcB = srcX;
                            byte* srcG = srcX + 1;
                            byte* srcR = srcX + 2;
                            int srcRestY = srcHeight;
                            int dstRestY = dstHeight;

                            int y = 0;
                            int sumB = 0;
                            int sumG = 0;
                            int sumR = 0;

                            while (y < dstHeight)
                            {
                                int N = (dstRestY < srcRestY) ? dstRestY : srcRestY;

                                sumB += *srcB * N;
                                sumG += *srcG * N;
                                sumR += *srcR * N;

                                dstRestY -= N;
                                if (dstRestY == 0)
                                {
                                    srcB += sStride;
                                    srcG += sStride;
                                    srcR += sStride;
                                    dstRestY = dstHeight;
                                }

                                srcRestY -= N;
                                if (srcRestY == 0)
                                {
                                    *dstB = (byte)(sumB / srcHeight);
                                    *dstG = (byte)(sumG / srcHeight);
                                    *dstR = (byte)(sumR / srcHeight);
                                    dstB += dstStride;
                                    dstG += dstStride;
                                    dstR += dstStride;
                                    y++;
                                    srcRestY = srcHeight;
                                    sumB = 0;
                                    sumG = 0;
                                    sumR = 0;
                                }
                            } // while
                            srcX += 3;
                            dstX += 3;
                        } // for
                        #endregion //垂直縮小処理
                    }
                    else
                    {
                        #region 垂直拡大処理
                        int sStride = dstWidth * 3;
                        byte* srcX = buff;
                        byte* dstX = dst;
                        for (int x = 0; x < dstWidth; x++)
                        {
                            byte* dstB = dstX;
                            byte* dstG = dstX + 1;
                            byte* dstR = dstX + 2;
                            byte* srcB = srcX;
                            byte* srcG = srcX + 1;
                            byte* srcR = srcX + 2;
                            int dstRestY = dstHeight;

                            int y = 0;

                            while (y < dstHeight)
                            {
                                if (dstRestY >= srcHeight)
                                {
                                    *dstB = *srcB;
                                    *dstG = *srcG;
                                    *dstR = *srcR;
                                    dstRestY -= srcHeight;
                                }
                                else
                                {
                                    int N = srcHeight - dstRestY;
                                    *dstB = (byte)((*srcB * (srcHeight - N) + *(srcB + sStride) * N) / srcHeight);
                                    *dstG = (byte)((*srcG * (srcHeight - N) + *(srcG + sStride) * N) / srcHeight);
                                    *dstR = (byte)((*srcR * (srcHeight - N) + *(srcR + sStride) * N) / srcHeight);
                                    srcB += sStride;
                                    srcG += sStride;
                                    srcR += sStride;
                                    dstRestY = dstHeight - N;
                                }

                                dstB += dstStride;
                                dstG += dstStride;
                                dstR += dstStride;
                                y++;
                            } // while
                            srcX += 3;
                            dstX += 3;
                        } // for
                        #endregion
                    } // if
                } // fixed
            } // unuse // usingやfixedを使うとネストが深くなりすぎる！！！
        }
        #region  いろいろな組み合わせ
        // ポインタ系
        public static void resizeImage(IntPtr srcPtr, int srcWidth, int srcHeight, int srcStride,
            IntPtr dstPtr, int dstWidth, int dstHeight, int dstStride)
        {
            unsafe
            {
                byte* src = (byte*)srcPtr;
                byte* dst = (byte*)dstPtr;
                resizeImage(src, srcWidth, srcHeight, srcStride, dst, dstWidth, dstHeight, dstStride);
            }
        }

        public static void resizeImage(IntPtr srcPtr, int srcWidth, int srcHeight, int srcStride,
            byte[] dstByte, int dstWidth, int dstHeight, int dstStride)
        {
            unsafe
            {
                byte* src = (byte*)srcPtr;
                fixed (byte* dst = dstByte)
                {
                    resizeImage(src, srcWidth, srcHeight, srcStride, dst, dstWidth, dstHeight, dstStride);
                }
            }
        }

        public static void resizeImage(byte[] srcByte, int srcWidth, int srcHeight, int srcStride,
            IntPtr dstPtr, int dstWidth, int dstHeight, int dstStride)
        {
            unsafe
            {
                fixed (byte* src = srcByte)
                {
                    byte* dst = (byte*)dstPtr;
                    resizeImage(src, srcWidth, srcHeight, srcStride, dst, dstWidth, dstHeight, dstStride);
                }
            }
        }

        public static void resizeImage(byte[] srcByte, int srcWidth, int srcHeight, int srcStride,
            byte[] dstByte, int dstWidth, int dstHeight, int dstStride)
        {
            unsafe
            {
                fixed (byte* src = srcByte)
                {
                    fixed (byte* dst = dstByte)
                    {
                        resizeImage(src, srcWidth, srcHeight, srcStride, dst, dstWidth, dstHeight, dstStride);
                    }
                }
            }
        }

        // bitmap系
        public static void resizeImage(byte[] srcPtr, int srcWidth, int srcHeight, int srcStride,
            Bitmap dstBmp)
        {
            BitmapData dstData = dstBmp.LockBits(new Rectangle(0, 0, dstBmp.Width, dstBmp.Height), ImageLockMode.WriteOnly, PixelFormat.Format24bppRgb);
            resizeImage(srcPtr, srcWidth, srcHeight, srcStride,
                dstData.Scan0, dstData.Width, dstData.Height, dstData.Stride);
            dstBmp.UnlockBits(dstData);
        }

        public static void resizeImage(Bitmap srcBmp,
            IntPtr dstPtr, int dstWidth, int dstHeight, int dstStride)
        {
            BitmapData srcData = srcBmp.LockBits(new Rectangle(0, 0, srcBmp.Width, srcBmp.Height), ImageLockMode.ReadOnly, PixelFormat.Format24bppRgb);
            resizeImage(srcData.Scan0, srcData.Width, srcData.Height, srcData.Stride,
                dstPtr, dstWidth, dstHeight, dstStride);
            srcBmp.UnlockBits(srcData);
        }

        public static void resizeImage(IntPtr srcPtr, int srcWidth, int srcHeight, int srcStride,
            Bitmap dstBmp)
        {
            BitmapData dstData = dstBmp.LockBits(new Rectangle(0, 0, dstBmp.Width, dstBmp.Height), ImageLockMode.WriteOnly, PixelFormat.Format24bppRgb);
            resizeImage(srcPtr, srcWidth, srcHeight, srcStride,
                dstData.Scan0, dstData.Width, dstData.Height, dstData.Stride);
            dstBmp.UnlockBits(dstData);
        }
        #endregion // いろいろな組み合わせ

        // 2次元データを上下を反転する
        // 内部で3倍とかはしないので、必要ならwidth*3で呼ぶこと
        unsafe static public void flipud(byte* data, int width, int height)
        {
            byte* src = data;
            byte* dst = src + (height - 1) * width;
            for (int sy = 0, dy = height - 1; sy < dy; sy++, dy--)
            {
                byte* p = src;
                byte* q = dst;
                for (int i = width - 1; i >= 0; i--)
                {
                    byte tmp = *p;
                    *p++ = *q;
                    *q++ = tmp;
                }
                src += width;
                dst -= width;
            }
        }
        #region いろいろな組み合わせ
        unsafe public static void flipud(byte[] data, int width, int height)
        {
            fixed (byte* dataAddress = data)
            {
                flipud(dataAddress, width, height);
            }
        }

        public static void flipud(Bitmap bmp)
        {
            BitmapData bmpData = bmp.LockBits(new Rectangle(0, 0, bmp.Width, bmp.Height), ImageLockMode.ReadWrite, PixelFormat.Format24bppRgb);
            unsafe
            {
                byte* data = (byte*)bmpData.Scan0;
                flipud(data, bmpData.Stride, bmpData.Height);
            }
            bmp.UnlockBits(bmpData);
        }
        #endregion

        // ある画像の長辺をNに縮小したときの、幅と高さを求める
        // (長辺は自動的にNになる)
        // susieの短辺長は、小数点以下切り捨てになってる
        static public void CalcSmallSize(int w, int h, int N, out int width, out int height)
        {
            if (w > h)
            {
                height = h * N / w;
                width = N;
            }
            else
            {
                width = w * N / h;
                height = N;
            }
        }

    }
}
